/*
#############################################################################
#	MINIMUM SPANNING TREE - PROBLEM                                         #
#		KRUSKAL ALGORITHM vs PRIM ALGORITHM                                 #
#									BEYCAN KAHRAMAN - 040020337             #
#############################################################################
*/

#include 	<stdio.h>
#include 	<stdlib.h>
#include 	<time.h>		// Time Libraries Used For Clocking the 

#define 	DEF_MIN		32000	// used in PRIM ALG (min initial measures)
#define 	LOOP		20000	// Looping # for Analysis of Algorithms

/***************************************************************************
	STRUCTURE EDGE:
		Every edge has two nodes  (node1, node2)
		Every edge has its measurement (measure)
		We have a set method to initialize the edges
***************************************************************************/
typedef struct Edges
{
	int node1, node2, measure;
	
	void set(int n1, int n2, int m)
	{
		node1 	= n1;
		node2 	= n2;
		measure = m;
	}
}
Edge;

/***************************************************************************
	FUNCTION DECLARATIONS
***************************************************************************/
void ReadFromFile 	( Edge **in, Edge **out, int &nOE, int &nON, int t );
void Kruskal 		( Edge *in,  Edge *out,  int nOE,  int nON  );
void Prim    		( Edge *in,  Edge *out,  int nOE,  int nON  );
void PrintEdge ( Edge *in, int size );
void mergeSort ( int start, int end, Edge *in );


/*==========================================================================
	START OF THE MAIN PROGRAM
==========================================================================*/
int main (  )
{
	Edge 	*edges, *minSpanningTree; // initial edges  &  solution edges
	
	int 	numOfEdges, numOfNodes;
	int 	i, t;
	int 	start, end;
	
	for ( i = 0; i < 3; i++ )
	{
		// we read every network once
		ReadFromFile( &edges, &minSpanningTree, numOfEdges, numOfNodes, i );

		// get the current time (starting time in miliseconds)
		start = clock();
		// call PRIM Function , LOOP times
		for ( t = 0; t < LOOP; t++ )
			Prim    ( edges, minSpanningTree, numOfEdges, numOfNodes );
		// get the last time
		end = clock();
		// print the solution edge
		PrintEdge ( minSpanningTree, numOfNodes-1 );
		// calculate the time for the function for LOOP times
		printf ( "    time for PRIM    (network %d) :    %d ms\n\n", i+1, end - start );
		
		// Here, i tried to use mergeSort out of the Kruskal Algorithm
		// and See that the Algorithm Works 5 times faster than with
		// sorting in every loop inside
		
		//mergeSort ( 0, numOfEdges - 1, edges );	// COULD BE REPLACED (*)
		
		// get the starting time again
		start = clock();
		// call KRUSKAL Function , LOOP times
		for ( t = 0; t < LOOP; t++ )
			Kruskal ( edges, minSpanningTree, numOfEdges, numOfNodes );
		// get the last time
		end = clock();
		// print the solution edge
		PrintEdge ( minSpanningTree, numOfNodes-1 );
		// calculate the time for the function for LOOP times
		printf ( "    time for KRUSKAL (network %d) :    %d ms\n\n", i+1, end - start );
		
		free ( edges );				// freeing the two edges
		free ( minSpanningTree );	
	}
	
    system ( "PAUSE" );
    return 0;
}

/*__________________________________________________________________________

FUNCTION NAME 		: 	KRUSKAL 
AIM OF THE FUNCTION	: 	using Kruskal Algorithm

VALUES				:   IN  (edges that have read from file)
						OUT (solution edge)
						nOE (number of Edges)
						nON (number of Nodes)

WORKING				: 	the function takes the given graph-matrix (in) and
						after sorting the graph according to their measures
						creates min trees and lastly join these graphs

SOLUTION			:   solution graph is OUT edge.

NOTE (*)			:   Both main function and Kruskal Function have a part
						'COULD BE REPLACED'. If the given graph has sorted 
						once no need to sort the edges again. So the 
						algorithm runs very faster
__________________________________________________________________________*/

void Kruskal ( Edge *in, Edge *out, int nOE, int nON )
{
	int i, j, counter = 0; 	// looping and counting values
	int add, tmpEdge = 0; 	// tmp values
	
	// used to understand if the node has used 
	//      used[i] = D  means  i.th node has used
	//      and it is in the Dth graph
	//      used[i] = 0  means  has not used before
	
	int *used = (int *) calloc( nON, sizeof(int) );
	
	mergeSort ( 0, nOE - 1, in );		// COULD BE REPLACED (*)
	
	// add numberOfNodes-1 edge to the solution graph
	for ( i = 0; i < nOE && counter < nON-1; i++ )
	{
		// if one of the node has not used, add to the solution graph
		if ( used[in[i].node1] == 0 || used[in[i].node2] == 0 )
		{
			add = tmpEdge;
			if ( used[in[i].node1] + used[in[i].node2] == 0 )
			{
				add++;
				++tmpEdge;
			}
			else
			{
				tmpEdge = add;
				add = used[in[i].node1] + used[in[i].node2];
			}
			
			// add the min edge to the graph
			used[in[i].node1] = add;
			used[in[i].node2] = add;
			
			out[counter++].set ( in[i].node1, in[i].node2, in[i].measure );
		}
		// if the nodes are in different graphes, join the graphs
		else if ( used[in[i].node1] != used[in[i].node2] )
		{
			add 	= used[in[i].node1];
			tmpEdge = used[in[i].node2];
			
			out[counter++].set ( in[i].node1, in[i].node2, in[i].measure );
			// join the graphs
			for( j = 0; j < nON; j++ )
				if ( used[j] == tmpEdge )
					used[j] = add;
		}
	}
	
	free ( used );	// freeing the memory
}

/*__________________________________________________________________________

FUNCTION NAME 		: 	PRIM 
AIM OF THE FUNCTION	: 	using Prim Algorithm

VALUES				:   IN  (edges that have read from file)
						OUT (solution edge)
						nOE (number of Edges)
						nON (number of Nodes)

WORKING				: 	the function takes the given graph-matrix (in) and
						after sorting the graph according to their measures
						and neighbourhood it will create the solution graph

SOLUTION			:   solution graph is OUT edge.
__________________________________________________________________________*/

void Prim ( Edge *in, Edge *out, int nOE, int nON )
{
	int i, counter = 0; 	// looping and counting values
	int minEdge, min; 		// for finding the min element
	
	// used to understand if the node has used 
	// used[i]=1  means  i.th node has used, used[i] = 0  has not
	int *used = (int *) calloc( nON, sizeof(int) );
	
	used[0] = 1;
	
	// add numberOfNodes-1 edge to the solution graph
	while ( counter < nON-1 )
	{
		min = DEF_MIN;
		// find the minimum measured neighbour of the nodes of the graph
		for( i = 0; i < nOE; i++ )
		{
			if ( used[in[i].node1] + used[in[i].node2] == 1 && in[i].measure < min )
			{
				min = in[i].measure;
				minEdge = i;
			}
		}
		min = used[in[minEdge].node2] > 0 ? in[minEdge].node1 : in[minEdge].node2;
		// add the min neighbour to the graph
		used[min] = 1;
		out[counter++].set ( in[minEdge].node1, in[minEdge].node2, in[minEdge].measure );
	}
	
	free ( used );	// freeing the memory
}

/***************************************************************************
	Aim Of the ReadFromFile Function  : 
	        Reading The Matrixes From File
	        Initializing The Size Of The Edges ( IN, OUT )
	        Setting the Initial Elements of the IN Edge Structure
	        Initializes numberOfEdges (nOE) and  numberOfNodes (nON)
***************************************************************************/
void ReadFromFile ( Edge **in, Edge **out, int &nOE, int &nON, int t )
{
	char c[] = "matrix1.txt\0";
	int i, a, b, m;
	c[6] = t + '1';
	
	FILE *f = fopen ( c, "r" );
	
	if ( f == NULL ){
		printf( "ERROR in OPENING FILE : %s\n", c );
		system( "PAUSE" );
		exit( -1 );
	}
	
	fscanf ( f, "%d\t%d\n", &nOE, &nON );
	
	*in 	= (Edge *) malloc( nOE*sizeof(Edge) );
	*out	= (Edge *) malloc( nON*sizeof(Edge) );
	
	for( i = 0; i < nOE; i++  )
	{
		fscanf ( f, "%d\t%d\t%d\n", &a, &b, &m );
		(*in)[i].set ( a-1, b-1, m );
	}
	
	fclose ( f );
}

/***************************************************************************
	Aim Of the PrintEdge Function  :        Printing The Solution Edges
***************************************************************************/
void PrintEdge ( Edge *in, int size )
{
	int i, total = 0;
	printf("------------------------------------------------\n");
	for ( i = 0; i<size; i++ )
	{
		total += in[i].measure; // Calculating the Total Measurement
		printf ("%d\t%d\t%d\n", in[i].node1 + 1, in[i].node2 + 1, in[i].measure );
	}
	printf ( "\nTotal Measure\t%d\n", total );
	printf("------------------------------------------------\n\n");
}

/***************************************************************************
	Aim Of the mergeSort Function  : 
		              Sorting the Given Edges for Kruskal Algorithm use
***************************************************************************/
void merge ( int start, int middle, int end, Edge *in )
{
	int i = start, 
		j = middle + 1;
	int k, 
		size = end - start + 1;
	
	Edge *newEdge = (Edge *) malloc( size*sizeof(Edge) );

	for ( k = 0; k < size; k ++ )
		if ( in[i].measure < in[j].measure && i <= middle || j > end )
			newEdge[k] = in[i++];
		else
			newEdge[k] = in[j++];

	for ( i = 0; i < size; i ++ )
		in[start + i] = newEdge[i];
	
	free ( newEdge );
}

void mergeSort ( int start, int end, Edge *in )
{
	if (start == end) return;

	int  middle = (start + end) / 2;

	mergeSort (start, middle, in);
	mergeSort (middle + 1, end, in);

	merge (start, middle, end, in);
}
